{
  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixpkgs-unstable";
    flake-utils = {
      url = "github:numtide/flake-utils";

    };
  };
  outputs = {self, nixpkgs, flake-utils, ... }:
    flake-utils.lib.eachDefaultSystem (system: 
      let pkgs = nixpkgs.legacyPackages.${system}; in
      {
        devShell = pkgs.mkShell {
          buildInputs = with pkgs; [
            pympress
            typst
            tinymist
          ];
        };
        packages.build = pkgs.writeShellScriptBin "present" ''
          ${pkgs.typst}/bin/typst compile main.typ
        '';
        packages.present = pkgs.writeShellScriptBin "present" ''
          ${pkgs.pympress}/bin/pympress main.pdf
        '';
        packages.default = pkgs.writeShellScriptBin "present" ''
          ${pkgs.typst}/bin/typst compile main.typ
          ${pkgs.pympress}/bin/pympress main.pdf
        '';
      });
}