{
  nixpkgs.overlays = let
    newpkgs =
      import
        (builtins.fetchTarball {
          url = "https://github.com/NixOS/nixpkgs/archive/abec03b635287cfb8ab2b3f9ecfceaefb2b4132f.tar.gz";
          sha256 = "11569zqsvnk4prp3vv58lf1lpijbf319xnp9qdjjrninl1w6h0ib";
        })
        {
          config = config.nixpkgs.config;
          system = pkgs.stdenv.hostPlatform.system;
        };
  in
  [
    (self: super: {
      wivrn = newpkgs.wivrn.override { cudaSupport = true; };
    })
  ];
}
