{
  inputs.nixpkgs.url = "github:nixos/nixpkgs/nixos-unstable";
  inputs.flake-utils.url = "github:numtide/flake-utils";
  outputs =
    {
      self,
      nixpkgs,
      flake-utils,
      ...
    }:
    flake-utils.lib.eachDefaultSystem (system: let pkgs = nixpkgs.legacyPackages.${system}; in rec {
      devShells.default = (pkgs.buildFHSEnv {
        name = "buildroot-fhs-env";
        multiPkgs = pkgs: (with pkgs; [
          file
          libgcc
          gcc
          glibc
          gnumake
          automake
          libtool
          texinfo
          bison
          flex
          gawk
          git
          xxd
          curl
          wget
          gptfdisk
          gperf
          cpio
          bc
          screen
          texinfo
          unzip
          gmp
          mpfr
          libmpc
          openssl
          ncurses
          glib
          pixman
          libyaml
          patchutils
          python312Packages.pip
          zlib
          dtc
          dosfstools
          mtools
          multipath-tools
          rsync
        ]);
        runScript = "fish";
      }).env;
    });
}
