import torch.nn as nn
import torch.nn.functional as F
import torch

class FullyConnectedNet(nn.Module):

    #TODO Impelment a fully connected neural network with the following architecture:
    # 1. linear layer with in_features: 32*32*3, out_features: 400
    # 2. ReLU activation
    # 3. linear layer with in_features: 400, out_features: 120
    # 4. ReLU activation
    # 5. linear layer with in_features: 120, out_features: 84
    # 6. ReLU activation
    # 7. linear layer with in_features: 84, out_features: 10

    def __init__(self):
        super(FullyConnectedNet, self).__init__()
        ...

    def forward(self, x):
        ...

class SmallConvolutionNet(nn.Module):
    #TODO Implement a small convolutional neural network with the following architecture:
    # 1. convolutional layer with in_channels: 3, out_channels: 6, kernel_size: 5
    # 2. ReLU activation
    # 3. max pooling layer with kernel_size: 2, stride: 2
    # 4. convolutional layer with in_channels: 6, out_channels: 16, kernel_size: 5
    # 5. ReLU activation
    # 6. max pooling layer with kernel_size: 2, stride: 2
    # 7. flatten the output of the previous layer
    # 8. linear layer with in_features: 400 = (16*5*5), out_features: 120
    # 9. ReLU activation
    # 10. linear layer with in_features: 120, out_features: 84
    # 11. ReLU activation
    # 12. linear layer with in_features: 84, out_features: 10

    def __init__(self):
        super(SmallConvolutionNet, self).__init__()
        ...

    def forward(self, x):
        ...
    
class LargeConvolutionNet(nn.Module):
    #TODO Implement a large convolutional neural network with the following architecture:
    # 1. convolutional layer with in_channels: 3, out_channels: 32, kernel_size: 3, padding: 1
    # 2. ReLU activation
    # 3. max pooling layer with kernel_size: 2, stride: 2
    # 4. convolutional layer with in_channels: 32, out_channels: 64, kernel_size: 3, padding: 1
    # 5. ReLU activation
    # 6. max pooling layer with kernel_size: 2, stride: 2
    # 7. convolutional layer with in_channels: 64, out_channels: 128, kernel_size: 3, padding: 1
    # 8. ReLU activation
    # 9. max pooling layer with kernel_size: 2, stride: 2
    # 10. flatten the output of the previous layer
    # 11. linear layer with in_features: 2048 (= 128*4*4), out_features: 512
    # 12. ReLU activation
    # 13. linear layer with in_features: 512, out_features: 256
    # 14. ReLU activation
    # 15. linear layer with in_features: 256, out_features: 10

    def __init__(self):
        super(LargeConvolutionNet, self).__init__()
        ...

    def forward(self, x):
        ...
    
class AdvancedConvolutionNet(nn.Module):
    #TODO Implement an advanced convolutional neural network with the following architecture:
    # 1. convolutional layer with in_channels: 3, out_channels: 32, kernel_size: 3, padding: 1
    # 2. 2d batch normalization with 32 features
    # 3. ReLU activation
    # 4. max pooling layer with kernel_size: 2, stride: 2
    # 5. convolutional layer with in_channels: 32, out_channels: 64, kernel_size: 3, padding: 1
    # 6. 2d batch normalization with 64 features
    # 7. ReLU activation
    # 8. max pooling layer with kernel_size: 2, stride: 2
    # 9. convolutional layer with in_channels: 64, out_channels: 128, kernel_size: 3, padding: 1
    # 10. 2d batch normalization with 128 features
    # 11. ReLU activation
    # 12. max pooling layer with kernel_size: 2, stride: 2
    # 13. flatten the output of the previous layer
    # 14. linear layer with in_features: 2048 (= 128*4*4), out_features: 512
    # 15. ReLU activation
    # 16. dropout layer with p=0.5
    # 17. linear layer with in_features: 512, out_features: 256
    # 18. ReLU activation
    # 19. dropout layer with p=0.5
    # 20. linear layer with in_features: 256, out_features: 10

    def __init__(self):
        super(AdvancedConvolutionNet, self).__init__()
        ...

    def forward(self, x):
        ...
    
class Encoder(nn.Module):
    #TODO Implement an encoder with the following architecture:
    # 1. convolutional layer with in_channels: 3, out_channels: 8, kernel_size: 4, stride: 2, padding: 1
    # 2. ReLU activation
    # 3. convolutional layer with in_channels: 8, out_channels: 16, kernel_size: 4, stride: 2, padding: 1
    # 4. ReLU activation
    # 5. convolutional layer with in_channels: 16, out_channels: 32, kernel_size: 4, stride: 2, padding: 1
    # 6. ReLU activation
    # 7. convolutional layer with in_channels: 32, out_channels: 16, kernel_size: 3, stride: 1, padding: 1
    # 8. ReLU activation

    def __init__(self):
        super(Encoder, self).__init__()
        ...

    def forward(self, x):
        ...

class Decoder(nn.Module):
    #TODO Implement a decoder with the following architecture:
    # 1. transposed convolutional layer with in_channels: 16, out_channels: 32, kernel_size: 3, stride: 1, padding: 1
    # 2. ReLU activation
    # 3. transposed convolutional layer with in_channels: 32, out_channels: 16, kernel_size: 4, stride: 2, padding: 1
    # 4. ReLU activation
    # 5. transposed convolutional layer with in_channels: 16, out_channels: 8, kernel_size: 4, stride: 2, padding: 1
    # 6. ReLU activation
    # 7. transposed convolutional layer with in_channels: 8, out_channels: 3, kernel_size: 4, stride: 2, padding: 1
    # 8. limit the output values to be between 0 and 1 simply by clamping the output

    def __init__(self):
        super(Decoder, self).__init__()
        ...

    def forward(self, x):
        ...

class Autoencoder(nn.Module):
    def __init__(self):
        super(Autoencoder, self).__init__()
        self.encoder = Encoder()
        self.decoder = Decoder()

    def forward(self, x):
        encoded = self.encoder(x)
        decoded = self.decoder(encoded)
        return decoded
    

