import numpy as np

from predictor import Predictor
from decision_tree import DecisionTree

class RandomForest(Predictor):
    def __init__(self, num_trees: int,  num_features: int, max_depth: int, min_samples: int,) -> None:
        self.num_trees = num_trees
        self.max_depth = max_depth
        self.min_samples = min_samples
        self.num_features = num_features
        self.trees = [] # Use this list to store the trees that are part of the forest
        self.feature_sets = [] # Use this will to store the indices of the features used for each tree

    def fit(self, data: np.ndarray, labels: np.ndarray) -> None:
        """Creates a random forest of decision trees using Bagging and random feature selection for each tree.

        Args:
            data (np.ndarray): Overall data to be used for training, shape (num_data_points, num_features)
            labels (np.ndarray): Labels for the data, shape (num_data_points,)
        """
        
        ### YOUR CODE GOES HERE ###

    def predict(self, data: np.ndarray) -> np.ndarray:
        """Predicts the labels for the given data using the random forest. Each tree in the forest predicts the label
        and the majority vote is taken as the final prediction. As each tree only uses a subset of features, the
        prediction is done using only those features per tree.

        Args:
            data (np.ndarray): Data to be used for prediction, shape (num_data_points, num_features)

        Returns:
            np.ndarray: Predicted labels for the data, shape (num_data_points,)
        """
        ### YOUR CODE GOES HERE ###